IF EXISTS
(
    SELECT *
    FROM SYS.OBJECTS
    WHERE NAME = 'UFD_EST_PROD_TRIB_PIS_COFINS'
)
    DROP FUNCTION [dbo].[UFD_EST_PROD_TRIB_PIS_COFINS];
GO


CREATE FUNCTION [dbo].[UFD_EST_PROD_TRIB_PIS_COFINS]
(@CD_EMP                INT,
 @CD_FILIAL             INT,
 @CD_MOV_OP             INT,
 @CD_PROD               INT,
 @CD_NT_OP              INT,
 @VLR_PROD_BASE_IMPOSTO MONEY,
 @REGIME_DOC			TINYINT,
 @CD_DOC				INT = NULL,
 @TP_DOC				INT = NULL,
 @VLR_DEDUZIR			MONEY = NULL
) 
RETURNS @UFD_RETURN TABLE
(CD_CST_PIS                       INT,
 PERC_PIS                         MONEY,
 VLR_BASE_PIS                     MONEY,
 VLR_PIS                          MONEY,
 CD_CST_COFINS                    INT,
 PERC_COFINS                      MONEY,
 VLR_BASE_COFINS                  MONEY,
 VLR_COFINS                       MONEY,
 MOV_FLAG_NAO_TRIBUTAR_PIS_COFINS INT,
 PROD_PIS_COFINS                  INT,
 PROD_TIPO_TRIBUTACAO             INT,
 PROD_FLAG_TRIB_PIS_COFINS_PROD   INT,
 PROD_LISTA_PROD                  INT,
 NT_OP_CST                        INT,
 CST_TP_TRIB_PIS                  INT,
 CST_TP_TRIB_COFINS               INT
)
     BEGIN
         DECLARE @PERC_PIS MONEY;
         DECLARE @VLR_BASE_PIS MONEY;
         DECLARE @VLR_PIS MONEY;
         DECLARE @PERC_COFINS MONEY;
         DECLARE @VLR_BASE_COFINS MONEY;
         DECLARE @VLR_COFINS MONEY;
         DECLARE @FLAG_NAO_TRIBUTAR_PIS_COFINS INT;
         DECLARE @PIS_COFINS INT;
         DECLARE @TIPO_TRIBUTACAO INT;
         DECLARE @FLAG_TRIB_PIS_COFINS_PROD INT;
         DECLARE @LISTA_PROD INT;
         DECLARE @CST_PIS INT;
         DECLARE @CST_COFINS INT;
         DECLARE @CST_NT_OP INT;
         DECLARE @TP_TRANSA INT;
         DECLARE @TP_TRIB_CST_PIS INT;
         DECLARE @TP_TRIB_CST_COFINS INT;
         DECLARE @TP_REGIME_APURACAO_PISCOFINS INT;
		 DECLARE @TP_REGIME_APURACAO_ICMS INT;
         SET @PERC_PIS = 0;
         SET @VLR_BASE_PIS = 0;
         SET @VLR_PIS = 0;
         SET @PERC_COFINS = 0;
         SET @VLR_BASE_COFINS = 0;
         SET @VLR_COFINS = 0;
         SET @FLAG_NAO_TRIBUTAR_PIS_COFINS = 0;
         SET @PIS_COFINS = 0;
         SET @TIPO_TRIBUTACAO = 0;
         SET @FLAG_TRIB_PIS_COFINS_PROD = 0;
         SET @LISTA_PROD = 0;
         SET @CST_PIS = 0;
         SET @CST_COFINS = 0;
         SET @CST_NT_OP = 0;
         SET @TP_TRANSA = 0;
         SET @TP_TRIB_CST_PIS = 0;
         SET @TP_TRIB_CST_COFINS = 0;
         SET @TP_REGIME_APURACAO_PISCOFINS = 0;
		 SET @TP_REGIME_APURACAO_ICMS = 0;


		
		 /*Deduo ICMS*/

		 
			/* @CD_DOC --	CD_NF Da Entrada, Saida ou Cupom	
			 @TP_DOC	--0 = NFe, 1 = NFCe
			 @VLR_DEDUZIR = Se no for nulo, verificar se atende aos parametros, e deduz apenas ele.
			 */

		 DECLARE @DEDUZIR_ICMS_ST_BASE_PISCOFINS INT = NULL 
		 DECLARE @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS INT = NULL 
		 DECLARE @DATADEDUZIR DATE = NULL
		 DECLARE @DATADEDUZIR_SAIDA DATE = NULL
		 DECLARE @DATADEDUZIR_ENTRADA DATE = NULL
		 DECLARE @REGIME_TRIBUTARIO INT = NULL
		 DECLARE @REGIME_APURAC_PIS_COFINS INT = NULL
		 DECLARE @CFOP_DEDUZ_ICMS INT = 0

		 SELECT @DEDUZIR_ICMS_ST_BASE_PISCOFINS = ISNULL(DEDUZIR_ICMS_ST_BASE_PISCOFINS,0),
				@DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = ISNULL(DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS,0)--,
				--@REGIME_TRIBUTARIO = ISNULL(REGIME_TRIBUTARIO,0),
				--@REGIME_APURAC_PIS_COFINS = ISNULL(TP_REGIME_APURAC_PIS_COFINS,0)
		 FROM PRC_FILIAL 
		 WHERE CD_FILIAL = @CD_FILIAL

		 SET @DATADEDUZIR_SAIDA = ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS', 1, @CD_FILIAL)),0)
		 SET @DATADEDUZIR_ENTRADA = CASE ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS_NF_ENTRADA', 1, @CD_FILIAL)) , '2023-05-01')
										WHEN '' THEN '2023-05-01'
										ELSE ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS_NF_ENTRADA', 1, @CD_FILIAL)) , '2023-05-01')
										END


		 SELECT @CFOP_DEDUZ_ICMS = 1
		 FROM GLB_NT_OP OP
		 WHERE OP.CD_NT_OP = @CD_NT_OP
		 AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0



         --ANTES
         --A aliquota de Pis/Cofins para empresas do lucro presumido  diferenciada
         -- Quando lucro presumido buscar a alquota na tabela GLB_IMPOSTOS_GRP_ECON
         --AGORA

		-- @TP_REGIME_APURACAO_PISCOFINS Busca o tipo de regime de apurao de pis/cofins por filial -criado pelo 
		-- fato de existir cumulativo e nao cumulativo no mesmo grupo economico
		----@TP_REGIME_APURACAO_ICMS Busca o tipo de regime de apurao Icms por filial
		----Qdo Regime Simples Nacional no poder aplicar incidencia do imposto. Neste caso ser utilizado o CST = 99
		 SELECT @TP_REGIME_APURACAO_PISCOFINS = ISNULL(TP_REGIME_APURAC_PIS_COFINS, 0) , 
		        @TP_REGIME_APURACAO_ICMS =  ISNULL(REGIME_TRIBUTARIO, 0)  
         FROM PRC_FILIAL
         WHERE CD_FILIAL = @CD_FILIAL;
 
		 --Pega a natureza informada
         IF @CD_MOV_OP > 0
             BEGIN
                 SELECT @FLAG_NAO_TRIBUTAR_PIS_COFINS = ISNULL(FLAG_NAO_TRIBUTAR_PIS_COFINS, 0),
                        @TP_TRANSA = TP_MOV_OP_TRANSA
                 FROM GLB_MOV_OP
                 WHERE CD_MOV_OP = @CD_MOV_OP;
             END; 

         --Forca saida de mercadoria
         IF @CD_MOV_OP = 0
             BEGIN
                 SET @FLAG_NAO_TRIBUTAR_PIS_COFINS = 0;
                 SET @TP_TRANSA = 1;
             END;


	/*Deduo*/

		/*Entrada*/

		IF @TP_TRANSA = 0
		BEGIn
			IF @TP_REGIME_APURACAO_PISCOFINS = 0 AND @TP_REGIME_APURACAO_ICMS = 4
			BEGIN
				IF ISNULL(@CD_DOC,0) <> 0 /*cd_doc preenchido*/
				BEGIN

					SET @VLR_PROD_BASE_IMPOSTO = @VLR_PROD_BASE_IMPOSTO - (ISNULL((SELECT EST_NF_ENT_IT.VLR_ICMS_IT +
																					
																					ISNULL((CASE WHEN @DEDUZIR_ICMS_ST_BASE_PISCOFINS = 0 THEN 0  ELSE 
																					CASE WHEN EST_NF_ENT_IT.VLR_ICMS_RET > (VLR_TOT_IT/* + EST_NF_ENT_IT.VLR_IPI*/) THEN 0
																					ELSE EST_NF_ENT_IT.VLR_ICMS_RET END  
																																					   END),0)

																					FROM EST_NF_ENT_IT
																					INNER JOIN EST_NF_ENT ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT.CD_EMP
																											 AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT.CD_FILIAL
																											 AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT.CD_NF
																											 AND EST_NF_ENT_IT.DT_ENT = EST_NF_ENT.DT_ENT 
																					WHERE EST_NF_ENT_IT.CD_NF = @CD_DOC
																					AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL
																					AND EST_NF_ENT_IT.CD_EMP = @CD_EMP
																					AND CD_PROD = @CD_PROD
																					AND EST_NF_ENT_IT.DT_ENT >= @DATADEDUZIR_ENTRADA 
																					AND EXISTS (SELECT 1
																											 FROM GLB_NT_OP OP
																											 WHERE OP.CD_NT_OP = EST_NF_ENT_IT.CD_NT_OP
																											 AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0)),0)
																					
																					
																					)

				END
				ELSE -- ufd_Est_prod_trib_uf
				BEGIN
					SET @VLR_PROD_BASE_IMPOSTO = ISNULL(@VLR_PROD_BASE_IMPOSTO,0) - CASE 
																							WHEN @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = 1 AND GETDATE() >= @DATADEDUZIR_ENTRADA AND ISNULL(@CFOP_DEDUZ_ICMS,0) = 1
																							THEN ISNULL(@vlr_deduzir,0) 
																						ELSE 0 
																						END;;
				END
			END
		END

		/*Saida*/

		IF @TP_TRANSA = 1 AND @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = 1 
		BEGIn
		 IF @TP_DOC = 0 /*NFe*/
			BEGIN
					IF ISNULL(@CD_DOC,0) <> 0 /*cd_doc preenchido*/
					BEGIN

						SET @VLR_PROD_BASE_IMPOSTO = @VLR_PROD_BASE_IMPOSTO - (ISNULL((SELECT EST_NF_SAI_IT.VLR_ICMS_IT
																						FROM EST_NF_SAI_IT
																						INNER JOIN EST_NF_SAI ON EST_NF_SAI_IT.CD_EMP = EST_NF_SAI.CD_EMP
																												 AND EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI.CD_FILIAL
																												 AND EST_NF_SAI_IT.CD_NF = EST_NF_SAI.CD_NF
																												 AND EST_NF_SAI_IT.DT_EMI_NF = EST_NF_SAI.DT_EMI_NF 
																						WHERE EST_NF_SAI_IT.CD_NF = @CD_DOC
																						AND EST_NF_SAI_IT.CD_FILIAL = @CD_FILIAL
																						AND EST_NF_SAI_IT.CD_EMP = @CD_EMP
																						AND CD_PROD = @CD_PROD
																						AND EST_NF_SAI_IT.DT_EMI_NF >= @DATADEDUZIR_SAIDA  
																						AND EXISTS (SELECT 1
																												 FROM GLB_NT_OP OP
																												 WHERE OP.CD_NT_OP = EST_NF_SAI_IT.CD_NT_OP
																												 AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0)),0))

					END
					ELSE -- ufd_Est_prod_trib_uf
					BEGIN
					

						SET @VLR_PROD_BASE_IMPOSTO = ISNULL(@VLR_PROD_BASE_IMPOSTO,0) - CASE 
																							WHEN @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = 1 AND GETDATE() >= @DATADEDUZIR_SAIDA AND ISNULL(@CFOP_DEDUZ_ICMS,0) = 1
																							THEN ISNULL(@vlr_deduzir,0) 
																						ELSE 0 
																						END;
					END
				END
				ELSE /*NFCe*/
				BEGIN

						IF ISNULL(@CD_DOC,0) <> 0 /*cd_doc preenchido*/
						BEGIN

							SET @VLR_PROD_BASE_IMPOSTO = @VLR_PROD_BASE_IMPOSTO - (ISNULL((SELECT PDV_VD_IT.VLR_ICMS
																							FROM PDV_VD_IT
																							INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
																													 AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
																													 AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
																													 AND PDV_VD_IT.DT_VD = PDV_VD.DT_VD 
																							WHERE PDV_VD_IT.CD_VD = @CD_DOC
																							AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
																							AND PDV_VD_IT.CD_EMP = @CD_EMP
																							AND CD_PROD = @CD_PROD
																							AND PDV_VD_IT.DT_VD >= @DATADEDUZIR_SAIDA 
																							AND EXISTS (SELECT 1
																													 FROM GLB_NT_OP OP
																													 WHERE OP.CD_NT_OP = PDV_VD_IT.CD_NT_OP
																													 AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0)
																							),0)
																							)

						END
						ELSE -- ufd_Est_prod_trib_uf
						BEGIN
							SET @VLR_PROD_BASE_IMPOSTO = ISNULL(@VLR_PROD_BASE_IMPOSTO,0) - CASE 
																							WHEN @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = 1 AND GETDATE() >= @DATADEDUZIR_SAIDA AND ISNULL(@CFOP_DEDUZ_ICMS,0) = 1
																							THEN ISNULL(@vlr_deduzir,0) 
																						ELSE 0 
																						END;;
						END
				END
			END

		/*Saida - NFCe*/

	/*Fim deduo*/

		 --@VLR_PROD_BASE_IMPOSTO



         --Natureza tributa pis/cofins
         IF @FLAG_NAO_TRIBUTAR_PIS_COFINS = 0
             BEGIn

                 --Buscando Aliquota de PIS
                 --1 - PIS - NO CUMULATIVO
                 --2 - COFINS - NO CUMULATIVO
                 --32 - PIS - CUMULATIVO"
                 --33 - COFINS - CUMULATIVO



				
				IF (@REGIME_DOC = 3 AND @REGIME_DOC > 0 )
				BEGIN
					/* 32 para PIS (LUCRO PRESUMIDO) */
					SELECT TOP 1 @PERC_PIS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO =32;
					
					/* 33 para COFINS (LUCRO PRESUMIDO) */
					SELECT TOP 1 @PERC_COFINS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO = 33;
				END
				ELSE IF (@REGIME_DOC = 4 AND @REGIME_DOC > 0)
				BEGIN
					/* 32 para PIS (LUCRO REAL) */
					SELECT TOP 1 @PERC_PIS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO =1;
					
					/* 33 para COFINS (LUCRO REAL) */
					SELECT TOP 1 @PERC_COFINS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO = 2;
				END
				ELSE
				BEGIN
					SELECT TOP 1 @PERC_PIS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO = CASE
										  WHEN @TP_REGIME_APURACAO_PISCOFINS = 0
										  THEN 1
										  ELSE 32
									  END;

					--Buscando Aliquota de COFINS
					SELECT TOP 1 @PERC_COFINS = PERC_IMP
					FROM GLB_IMPOSTOS
					WHERE TIPO_IMPOSTO = CASE
										  WHEN @TP_REGIME_APURACAO_PISCOFINS = 0
										  THEN 2
										  ELSE 33
									  END;
				END
									  
                 --Calculando PIS
                 SET @VLR_BASE_PIS = @VLR_PROD_BASE_IMPOSTO;
                 SET @VLR_PIS = ROUND((@VLR_BASE_PIS * @PERC_PIS) / 100.00, 4);

                 --Calculando COFINS
                 SET @VLR_BASE_COFINS = @VLR_PROD_BASE_IMPOSTO;
                 SET @VLR_COFINS = ROUND((@VLR_BASE_COFINS * @PERC_COFINS) / 100.00, 4);
            
			 END; --IF @FLAG_NAO_TRIBUTAR_PIS_COFINS = 0







         --Se existir tributacao por por CFOP
         SELECT @CST_COFINS = CASE
                                  WHEN ISNULL(GLB_NT_OP.CST_COFINS, 0) = 0
                                  THEN @CST_COFINS
                                  ELSE ISNULL(GLB_NT_OP.CST_COFINS, 0)
                              END,
                @CST_PIS = CASE
                               WHEN ISNULL(GLB_NT_OP.CST_PIS, 0) = 0
                               THEN @CST_PIS
                               ELSE ISNULL(GLB_NT_OP.CST_PIS, 0)
                           END,
                @CST_NT_OP = CASE
                                 WHEN ISNULL(GLB_NT_OP.CST_PIS, 0) = 0
                                 THEN 0
                                 ELSE 1
                             END
         FROM GLB_NT_OP
         WHERE CD_NT_OP = @CD_NT_OP;
        
		 --se Nao possui CST de PIS/COFINS no CFOP
         IF @CST_PIS = 0
             BEGIN
                 SELECT @PIS_COFINS = ISNULL(PIS_COFINS, 0),
                        @TIPO_TRIBUTACAO = CASE
                                               WHEN @TP_TRANSA = 0
                                               THEN ISNULL(TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA, 0)
                                               ELSE ISNULL(TIPO_TRIBUTACAO_PIS_COFINS, 0)
                                           END,
                        @FLAG_TRIB_PIS_COFINS_PROD = ISNULL(FLAG_TRIB_PIS_COFINS_PROD, 0),
                        @LISTA_PROD = ISNULL(LISTA_PROD, 0),
                        @CST_COFINS = CASE
                                          WHEN @TP_TRANSA = 0
                                          THEN ISNULL((CASE
                                                           WHEN(isnull(FLAG_TRIB_PIS_COFINS_PROD, 0)) = 1
                                                           THEN EST_PROD.CD_CST_COFINS_ENTRADA
                                                           ELSE 0
                                                       END), 0)
                                          ELSE ISNULL((CASE
                                                           WHEN(isnull(FLAG_TRIB_PIS_COFINS_PROD, 0)) = 1
                                                           THEN EST_PROD.CD_CST_COFINS_SAIDA
                                                           ELSE 0
                                                       END), 0)
                                      END,
                       @CST_PIS = CASE
                                       WHEN @TP_TRANSA = 0
                                       THEN ISNULL((CASE
                                                        WHEN(isnull(FLAG_TRIB_PIS_COFINS_PROD, 0)) = 1
                                                        THEN EST_PROD.CD_CST_PIS_ENTRADA
                                                        ELSE 0
                                                    END), 0)
                                       ELSE ISNULL((CASE
                                                        WHEN(isnull(FLAG_TRIB_PIS_COFINS_PROD, 0)) = 1
                                                        THEN EST_PROD.CD_CST_PIS_SAIDA
                                                        ELSE 0
                                                    END), 0)
                                   END
                 FROM EST_PROD
                 WHERE CD_EMP = @CD_EMP
                       AND CD_PROD = @CD_PROD;
             END;


         --Nao possui CST de PIS/COFINS no CFOP nem por exceo do produto
         IF @CST_PIS = 0
             IF @CST_NT_OP = 0
                 BEGIN
                     SELECT @CST_COFINS = GLB_TRIB_PIS_COFINS_REGIME.CD_CST,
                            @CST_PIS = GLB_TRIB_PIS_COFINS_REGIME.CD_CST
                     FROM GLB_TRIB_PIS_COFINS_REGIME
                     WHERE GLB_TRIB_PIS_COFINS_REGIME.CD_LISTA = @LISTA_PROD
                           AND GLB_TRIB_PIS_COFINS_REGIME.TP_TRANSA = @TP_TRANSA
                           AND GLB_TRIB_PIS_COFINS_REGIME.TIPO_TRIBUTACAO = @TIPO_TRIBUTACAO
                           AND TIPO_REGIME = @TP_REGIME_APURACAO_PISCOFINS;
                 END;

         --==================================================================
         --Analisando PIS
         --==================================================================
         --Analisando se o CST e tributavel
         SELECT @TP_TRIB_CST_PIS = TP_TRIB
         FROM CST_PIS_COFINS
         WHERE CD_CST = @CST_PIS;

	    --Se for igual a zero nao possui imposto
         IF @TP_TRIB_CST_PIS = 0
             BEGIN
                 SET @PERC_PIS = 0;
                 SET @VLR_BASE_PIS = 0;
                 SET @VLR_PIS = 0;
             END;

         --Se for igual a so tem base
         IF @TP_TRIB_CST_PIS = 2
             BEGIN
                 SET @PERC_PIS = 0;
                 SET @VLR_PIS = 0;
             END;
         --==================================================================
         --Analisando COFINS
         --==================================================================
         --Analisando se o CST e tributavel
         SELECT @TP_TRIB_CST_COFINS = TP_TRIB,
				@PIS_COFINS = TP_TRIB
         FROM CST_PIS_COFINS
         WHERE CD_CST = @CST_COFINS;

         --Se for igual a zero nao possui imposto
         IF @TP_TRIB_CST_PIS = 0
             BEGIN
                 SET @PERC_COFINS = 0;
                 SET @VLR_BASE_COFINS = 0;
                 SET @VLR_COFINS = 0;
             END;

         --Se for igual a so tem base
         IF @TP_TRIB_CST_PIS = 2
             BEGIN
                 SET @PERC_COFINS = 0;
                 SET @VLR_COFINS = 0;
             END;
         --==================================================================

		 IF @VLR_BASE_PIS < 0 
		 BEGIN
			SET @CST_PIS=''
			SET @VLR_BASE_PIS=0
			SET @VLR_PIS=0
			SET @PERC_PIS=0
		 END 
		 
		 IF @VLR_BASE_COFINS < 0 
		 BEGIN
			SET @CST_COFINS=''
			SET @VLR_BASE_COFINS=0
			SET @VLR_COFINS=0
			SET @PERC_COFINS=0
		 END
		 
		 IF @TP_REGIME_APURACAO_ICMS  = 1 AND  @TP_TRANSA = 1  -- Filial optante pelo simples Nacional
			
			BEGIN
			SET @CST_PIS='49'
			SET @VLR_BASE_PIS=0
			SET @VLR_PIS=0
			SET @PERC_PIS=0
			
			SET @CST_COFINS='49'
			SET @VLR_BASE_COFINS=0
			SET @VLR_COFINS=0
			SET @PERC_COFINS=0

		 END;
		 
         INSERT INTO @UFD_RETURN
                SELECT @CST_PIS,
                       @PERC_PIS,
                       @VLR_BASE_PIS,
                       @VLR_PIS,
                       @CST_COFINS,
                       @PERC_COFINS,
                       @VLR_BASE_COFINS,
                       @VLR_COFINS,
                       @FLAG_NAO_TRIBUTAR_PIS_COFINS,
                       @PIS_COFINS,
                       @TIPO_TRIBUTACAO,
                       @FLAG_TRIB_PIS_COFINS_PROD,
                       @LISTA_PROD,
                       @CST_NT_OP,
                       @TP_TRIB_CST_PIS,
                       @TP_TRIB_CST_COFINS;
         RETURN;
     END;